<?php
// admin/view_students_by_class.php

include('../config.php');

// Only logged-in admins
if (!isset($_SESSION['admin_id'])) {
    header("Location: ../login/admin.php");
    exit();
}

$class_name = "";
$students = [];

if (isset($_POST['search_class'])) {
    $class_name = trim($_POST['class_id']);
    $stmt = $conn->prepare("SELECT * FROM students WHERE class_id = ? ORDER BY regno");
    $stmt->bind_param("s", $class_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $students = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}

// Fetch all distinct classes for dropdown
$classResult = $conn->query("SELECT DISTINCT class_id FROM students ORDER BY class_id");
$classes = [];
while ($row = $classResult->fetch_assoc()) {
    $classes[] = $row['class_id'];
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Admin - View Students by Class</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <h1>Admin Dashboard - View Students by Class</h1>

    <form method="post">
        <label>Select Class:</label>
        <select name="class_id" required>
            <option value="">-- Choose Class --</option>
            <?php foreach ($classes as $c): ?>
                <option value="<?= htmlspecialchars($c) ?>" <?= ($class_id == $c) ? "selected" : "" ?>>
                    <?= htmlspecialchars($c) ?>
                </option>
            <?php endforeach; ?>
        </select>
        <button type="submit" name="search_class">Search</button>
    </form>

    <?php if (!empty($students)): ?>
        <h2>Students in Class: <?= htmlspecialchars($class_name) ?></h2>
        <table border="1" cellpadding="5" cellspacing="0">
            <tr>
                <th>ID</th>
                <th>Reg No</th>
                <th>Name</th>
                <th>Class</th>
                <th>Subject</th>
            </tr>
            <?php foreach ($students as $s): ?>
            <tr>
                <td><?= htmlspecialchars($s['id']) ?></td>
                <td><?= htmlspecialchars($s['regno']) ?></td>
                <td><?= htmlspecialchars($s['name']) ?></td>
                <td><?= htmlspecialchars($s['class_name']) ?></td>
                <td><?= htmlspecialchars($s['subject_name']) ?></td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php elseif ($class_id && empty($students)): ?>
        <p>No students found in class <strong><?= htmlspecialchars($class_id) ?></strong>.</p>
    <?php endif; ?>

    <br><a href="dashboard.php">⬅ Back to Admin Dashboard</a>
</body>
</html>
