<?php
include('../config.php');

// Only logged-in admins
if (!isset($_SESSION['admin_id'])) {
    header("Location: ../login/admin.php");
    exit();
}

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM students WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->close();
    header("Location: manage_students.php");
    exit();
}

// Search functionality
$search = "";
if (isset($_GET['search']) && !empty($_GET['search'])) {
    $search = trim($_GET['search']);
    $stmt = $conn->prepare("SELECT * FROM students WHERE regno LIKE ? OR name LIKE ? OR class_id LIKE ? ORDER BY id DESC");
    $likeSearch = "%$search%";
    $stmt->bind_param("sss", $likeSearch, $likeSearch, $likeSearch);
    $stmt->execute();
    $result = $stmt->get_result();
    $students = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
} else {
    $result = $conn->query("SELECT * FROM students ORDER BY id DESC");
    $students = $result->fetch_all(MYSQLI_ASSOC);
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Manage Students</title>
    <link rel="stylesheet" href="../assets/style.css">
    <style>
        .search-box {
            margin-bottom: 15px;
        }
        .search-box input[type="text"] {
            padding: 5px;
            width: 250px;
        }
        .search-box button {
            padding: 6px 10px;
        }
    </style>
</head>
<body>
    <h1>Admin Dashboard - Manage Students</h1>

    <a href="create_student.php">➕ Add New Student</a><br><br>

    <!-- Search Form -->
    <form method="GET" class="search-box">
        <input type="text" name="search" placeholder="Search by Reg No, Name, or Class" value="<?= htmlspecialchars($search) ?>">
        <button type="submit">🔍 Search</button>
        <a href="manage_students.php"><button type="button">❌ Reset</button></a>
    </form>

    <table border="1" cellpadding="5" cellspacing="0">
        <tr>
            <th>ID</th>
            <th>Reg No</th>
            <th>Name</th>
            <th>Actions</th>
        </tr>
        <?php if (!empty($students)): ?>
            <?php foreach ($students as $s): ?>
            <tr>
                <td><?= htmlspecialchars($s['id']) ?></td>
                <td><?= htmlspecialchars($s['regno']) ?></td>
                <td><?= htmlspecialchars($s['name']) ?></td>
                <td>
                    <a href="edit_student.php?id=<?= $s['id'] ?>">✏ Edit</a> | 
                    <a href="manage_students.php?delete=<?= $s['id'] ?>" onclick="return confirm('Are you sure you want to delete this student?');">❌ Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="6">No students found.</td></tr>
        <?php endif; ?>
    </table>

    <br><a href="dashboard.php">⬅ Back to Admin Dashboard</a>
</body>
</html>
