<?php
include('../config.php');

// Only logged-in admins
if (!isset($_SESSION['admin_id'])) {
    header("Location: ../login/admin.php");
    exit();
}

// Handle delete exam
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM exams WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->close();
    header("Location: delete_exams.php");
    exit();
}

// Fetch all exams
$result = $conn->query("SELECT * FROM exams ORDER BY id DESC");
$exams = $result->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Delete Exams</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <h1>Admin Dashboard - Delete Uploaded Exams</h1>

    <table border="1" cellpadding="5" cellspacing="0">
        <tr>
            <th>ID</th>
            <th>Exam Title</th>
            <th>Subject ID</th>
            <th>Status</th>
            <th>Delete</th>
        </tr>
        <?php if (!empty($exams)): ?>
            <?php foreach ($exams as $e): ?>
            <tr>
                <td><?= htmlspecialchars($e['id']) ?></td>
                <td><?= htmlspecialchars($e['title']) ?></td>
                <td><?= htmlspecialchars($e['subject_id']) ?></td>
                <td><?= htmlspecialchars($e['status']) ?></td>
                <td>
                    <a href="delete_exams.php?delete=<?= $e['id'] ?>" 
                       onclick="return confirm('Are you sure you want to delete this exam?');">❌ Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="7">No exams uploaded.</td></tr>
        <?php endif; ?>
    </table>

    <br><a href="dashboard.php">⬅ Back to Admin Dashboard</a>
</body>
</html>
