<?php
// admin/change_admin_login.php
include('../config.php');

// Ensure only admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header("Location: ../login/admin.php");
    exit();
}

$message = "";

// Handle form submit
if (isset($_POST['update_login'])) {
    $new_username = trim($_POST['username']);
    $new_password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    $stmt = $conn->prepare("UPDATE admins SET username = ?, password = ? WHERE id = ?");
    $stmt->bind_param("ssi", $new_username, $new_password, $_SESSION['admin_id']);
    
    if ($stmt->execute()) {
        $message = "✅ Admin login updated successfully!";
    } else {
        $message = "❌ Error updating login.";
    }

    $stmt->close();
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Change Admin Login</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <h1>Change Admin Login</h1>
    <?php if ($message): ?>
        <p><strong><?= $message ?></strong></p>
    <?php endif; ?>

    <form method="post">
        <label>New Username:</label>
        <input type="text" name="username" required><br><br>

        <label>New Password:</label>
        <input type="password" name="password" required><br><br>

        <button type="submit" name="update_login">Update Login</button>
    </form>

    <br><a href="dashboard.php">⬅ Back to Admin Dashboard</a>
</body>
</html>
