<?php
include('../config.php');

// Only logged-in admins
if (!isset($_SESSION['admin_id'])) {
    header("Location: ../login/admin.php");
    exit();
}

// Handle delete teacher
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM teachers WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->close();
    header("Location: manage_teachers.php");
    exit();
}

// Search functionality
$search = "";
if (isset($_GET['search']) && !empty($_GET['search'])) {
    $search = trim($_GET['search']);
    $stmt = $conn->prepare("SELECT * FROM teachers WHERE name LIKE ? OR username LIKE ? ORDER BY id DESC");
    $likeSearch = "%$search%";
    $stmt->bind_param("ss", $likeSearch, $likeSearch);
    $stmt->execute();
    $result = $stmt->get_result();
    $teachers = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
} else {
    $result = $conn->query("SELECT * FROM teachers ORDER BY id DESC");
    $teachers = $result->fetch_all(MYSQLI_ASSOC);
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Manage Teachers</title>
    <link rel="stylesheet" href="../assets/style.css">
    <style>
        .search-box {
            margin-bottom: 15px;
        }
        .search-box input[type="text"] {
            padding: 5px;
            width: 250px;
        }
        .search-box button {
            padding: 6px 10px;
        }
    </style>
</head>
<body>
    <h1>Admin Dashboard - Manage Teachers</h1>

    <a href="create_teacher.php">➕ Add New Teacher</a><br><br>

    <!-- Search Form -->
    <form method="GET" class="search-box">
        <input type="text" name="search" placeholder="Search by Name, Email, or Username" value="<?= htmlspecialchars($search) ?>">
        <button type="submit">🔍 Search</button>
        <a href="manage_teachers.php"><button type="button">❌ Reset</button></a>
    </form>

    <table border="1" cellpadding="5" cellspacing="0">
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Username</th>
            <th>Actions</th>
        </tr>
        <?php if (!empty($teachers)): ?>
            <?php foreach ($teachers as $t): ?>
            <tr>
                <td><?= htmlspecialchars($t['id']) ?></td>
                <td><?= htmlspecialchars($t['name']) ?></td>
                <td><?= htmlspecialchars($t['username']) ?></td>
                <td>
                    <a href="edit_teacher.php?id=<?= $t['id'] ?>">✏ Edit</a> | 
                    <a href="manage_teachers.php?delete=<?= $t['id'] ?>" onclick="return confirm('Are you sure you want to delete this teacher?');">❌ Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="5">No teachers found.</td></tr>
        <?php endif; ?>
    </table>

    <br><a href="dashboard.php">⬅ Back to Admin Dashboard</a>
</body>
</html>
