<?php include('../config.php');
if (!isset($_SESSION['admin_id']))
    header('Location: ../login/admin.php');
$msg = '';
$classes = $conn->query('SELECT id,class_name FROM classes');
$subjects = $conn->query('SELECT id,subject_name FROM subjects');
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $conn->real_escape_string($_POST['title']);
    $class_id = intval($_POST['class_id']);
    $subject_id = intval($_POST['subject_id']);
    $conn->query("INSERT INTO exams(title,subject_id,teacher_id,status,created_at) VALUES('" . $title . "',$subject_id,0,'pending',NOW())");
    $exam_id = $conn->insert_id;
    $dur = intval($_POST['duration']);
    $stmt = $conn->prepare('INSERT INTO exam_classes(exam_id,class_id,duration) VALUES(?,?,?)');
    $stmt->bind_param('iii', $exam_id, $class_id, $dur);
    $stmt->execute();
    if (isset($_FILES['exam_csv']) && $_FILES['exam_csv']['tmp_name']) {
        $fh = fopen($_FILES['exam_csv']['tmp_name'], 'r');
        $hdr = fgetcsv($fh);
        while (($row = fgetcsv($fh)) !== false) {
            list($q, $a, $b, $c, $d, $corr, $img) = array_pad($row, 7, '');
            $stmt = $conn->prepare('INSERT INTO questions(exam_id,question_text,option_a,option_b,option_c,option_d,correct_answer,image_path) VALUES(?,?,?,?,?,?,?,?)');
            $stmt->bind_param('isssssss', $exam_id, $q, $a, $b, $c, $d, $corr, $img);
            $stmt->execute();
        }
        fclose($fh);
    }
    if (isset($_POST['manual_q'])) {
        foreach ($_POST['manual_q'] as $i => $qtxt) {
            $a = $_POST['manual_a'][$i];
            $b = $_POST['manual_b'][$i];
            $c = $_POST['manual_c'][$i];
            $d = $_POST['manual_d'][$i];
            $corr = $_POST['manual_corr'][$i];
            $stmt = $conn->prepare('INSERT INTO questions(exam_id,question_text,option_a,option_b,option_c,option_d,correct_answer) VALUES(?,?,?,?,?,?,?)');
            $stmt->bind_param('issssss', $exam_id, $qtxt, $a, $b, $c, $d, $corr);
            $stmt->execute();
        }
    }
    $msg = 'Exam created.';
} ?><!doctype html>
<html>

<head>
    <link rel='stylesheet' href='../assets/style.css'>
    <script>function addQ() { let c = document.getElementById('manualQ'); let div = document.createElement('div'); div.innerHTML = `<label>Question</label><textarea name='manual_q[]' required></textarea><label>Option A</label><input name='manual_a[]' required><label>Option B</label><input name='manual_b[]' required><label>Option C</label><input name='manual_c[]' required><label>Option D</label><input name='manual_d[]' required><label>Correct (A/B/C/D)</label><input name='manual_corr[]' required><hr>`; c.appendChild(div); } </script>
</head>

<body>
    <div class='container'>
        <h2>Create Exam</h2><?php if ($msg)
            echo '<div class=notice>' . $msg . '</div>'; ?>
        <div class='form-card'>
            <form method='post' enctype='multipart/form-data'><label>Title</label><input name='title'
                    required><label>Class</label><select
                    name='class_id'><?php while ($r = $classes->fetch_assoc()) {
                        echo "<option value='{$r['id']}'>" . htmlspecialchars($r['class_name']) . "</option>";
                    } ?></select><label>Subject</label><select
                    name='subject_id'><?php while ($s = $subjects->fetch_assoc()) {
                        echo "<option value='{$s['id']}'>" . htmlspecialchars($s['subject_name']) . "</option>";
                    } ?></select><label>Duration
                    (minutes)</label><input name='duration' type='number' value='60' required><label>Upload CSV
                    (q,a,b,c,d,correct,image)</label><input type='file' name='exam_csv' accept='.csv'>
                <h3>Or Manual Entry</h3>
                <div id='manualQ'></div><button type='button' class='btn' onclick='addQ()'>Add
                    Question</button><br><br><button class='btn' type='submit'>Save Exam</button>
            </form>
        </div><a class='btn' href='dashboard.php'>Back</a>
    </div>
</body>

</html>