<?php
// admin/view_students_by_class.php
session_start();
include('../config.php');

// Only logged-in admin
if (!isset($_SESSION['admin_id'])) {
    header("Location: ../login/admin.php");
    exit();
}

$class = "";
$students = [];

if (isset($_POST['search_class'])) {
    $class = trim($_POST['class']);
    $stmt = $conn->prepare("SELECT * FROM students WHERE class = ? ORDER BY regno");
    $stmt->bind_param("s", $class);
    $stmt->execute();
    $result = $stmt->get_result();
    $students = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}

// Fetch all distinct classes for dropdown
$classResult = $conn->query("SELECT DISTINCT class FROM students ORDER BY class");
$classes = [];
while ($row = $classResult->fetch_assoc()) {
    $classes[] = $row['class'];
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Admin - View Students by Class</title>
    <link rel="stylesheet" href="../assets/style.css">
</head>
<body>
    <h1>Admin Dashboard - View Students by Class</h1>

    <form method="post">
        <label>Select Class:</label>
        <select name="class" required>
            <option value="">-- Choose Class --</option>
            <?php foreach ($classes as $c): ?>
                <option value="<?= htmlspecialchars($c) ?>" <?= ($class == $c) ? "selected" : "" ?>>
                    <?= htmlspecialchars($c) ?>
                </option>
            <?php endforeach; ?>
        </select>
        <button type="submit" name="search_class">Search</button>
    </form>

    <?php if (!empty($students)): ?>
        <h2>Students in Class: <?= htmlspecialchars($class) ?></h2>
        <table border="1" cellpadding="5" cellspacing="0">
            <tr>
                <th>ID</th>
                <th>Reg No</th>
                <th>Name</th>
                <th>Class</th>
                <th>Subject</th>
            </tr>
            <?php foreach ($students as $s): ?>
            <tr>
                <td><?= htmlspecialchars($s['id']) ?></td>
                <td><?= htmlspecialchars($s['regno']) ?></td>
                <td><?= htmlspecialchars($s['name']) ?></td>
                <td><?= htmlspecialchars($s['class']) ?></td>
                <td><?= htmlspecialchars($s['subject']) ?></td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php elseif ($class && empty($students)): ?>
        <p>No students found in class <strong><?= htmlspecialchars($class) ?></strong>.</p>
    <?php endif; ?>

    <br><a href="index.php">⬅ Back to Admin Dashboard</a>
</body>
</html>
